library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity test_pdm_to_pcm is 
end test_pdm_to_pcm;


architecture TB of test_pdm_to_pcm is

component pdm_to_pcm is
port (
  fifo_almost_empty : out STD_LOGIC;
  fifo_almost_full : out STD_LOGIC;
  fifo_rd_clk : in STD_LOGIC;
  fifo_rd_en : in STD_LOGIC;
  pcm_data : out STD_LOGIC_VECTOR (31 downto 0);
  pdm_clk : out STD_LOGIC_VECTOR (0 to 0);
  pdm_data : in STD_LOGIC_VECTOR(3 downto 0);
  resetn : in STD_LOGIC;
  start : in STD_LOGIC;
  sys_clock : in STD_LOGIC
);
end component pdm_to_pcm;
TYPE datArr is array (0 to 28) of std_logic_vector(3 downto 0);
CONSTANT pDat : datArr:=(
"0000",
              "1000",
              "1100",
              "1110",
              "1111",
              "0111",
              "1011",
              "0101",
              "1010",
              "1101",
              "1110",
              "1111",
              "1111",
              "1111",
              "1111",
              "1110",
              "0111",
              "1011",
              "0101",
              "1010",
              "1101",
              "1110",
              "1111",
              "0111",
              "0011",
              "0001",
              "0000",
              "0000",
              "0000");
              
signal fifo_almost_empty : STD_LOGIC;
signal fifo_almost_full : STD_LOGIC;
signal fifo_rd_clk : STD_LOGIC;
signal fifo_rd_en : STD_LOGIC;
signal pcm_data : STD_LOGIC_VECTOR (31 downto 0);
signal pdm_clk : STD_LOGIC_VECTOR (0 to 0);
signal pdm_data : STD_LOGIC_VECTOR(3 downto 0);
signal resetn : STD_LOGIC;
signal start : STD_LOGIC;
signal sys_clock : STD_LOGIC;
begin

DUT: component pdm_to_pcm port map (
  fifo_almost_empty => fifo_almost_empty,
  fifo_almost_full => fifo_almost_full,
  fifo_rd_clk => fifo_rd_clk,
  fifo_rd_en => fifo_rd_en,
  pcm_data => pcm_data,
  pdm_clk => pdm_clk,
  pdm_data => pdm_data,
  resetn => resetn,
  start => start,
  sys_clock => sys_clock
);

process
begin
  fifo_rd_clk <= '0';
  wait for 5.0 ns;
  fifo_rd_clk <= '1';
  wait for 5.0 ns;
end process;
--process
--begin
--  pdm_clk <= "0";
--  wait for 5.0 ns;
--  pdm_clk <= "1";
--  wait for 5.0 ns;
--end process;
process
begin
  sys_clock <= '0';
  wait for 5.0 ns;
  sys_clock <= '1';
  wait for 5.0 ns;
end process;
process
begin
  resetn <= '0';
  wait for 100 ns;
  resetn <= '1';
  wait;
end process;

fifo_rd_en <= '1';
start <= '1';

process
variable i:integer:=0;
begin
L1 : loop
pdm_data <= pDat(i);
i:=i+1;
if (i=28) then
i := 0;
end if;
wait for 1000 ns;
end loop L1;
end process;



end TB;

